<?php
/**
 * ------------------------------------------------------------------------
 * JA Load module Plugin for Joomla 2.5
 * ------------------------------------------------------------------------
 * Copyright (C) 2004-2011 J.O.O.M Solutions Co., Ltd. All Rights Reserved.
 * @license - GNU/GPL, http://www.gnu.org/licenses/gpl.html
 * Author: J.O.O.M Solutions Co., Ltd
 * Websites: http://www.joomlart.com - http://www.joomlancers.com
 * ------------------------------------------------------------------------
 */

defined('_JEXEC') or die('Restricted access');
jimport('joomla.plugin.plugin');
/**
 * Plugin Content JA Load Modules
 *
 * @package		Joomla
 * @subpackage	Content
 * @since 		1.5
 */
class plgContentJALoadmodule extends JPlugin
{
    /**
     * @var object
     */
    var $plugin;
    /**
     * @var object
     */
    var $plgParams;


    /**
     * Constructor
     *
     * For php4 compatability we must not use the __constructor as a constructor for plugins
     * because func_get_args ( void ) returns a copy of all passed arguments, NOT references.
     * This causes problems with cross-referencing necessary for the observer design pattern.
     *
     * @param	object	$subject The object to observe
     * @param	object 	$config  The object to observe
     */
    function plgContentJALoadmodule(&$subject)
    {
        parent::__construct($subject);
        $this->plugin = JPluginHelper::getPlugin('content', 'jaloadmodule');
        $this->plgParams = new JRegistry($this->plugin->params);
    }


    /**
     * Popup prepares content method
     *
     * @param 	string	article
     * @param	object	param of ja load modules
     * @param	int		page number
     * @return	article
     */
    function onContentPrepare($context, &$row, &$params, $page = 0)
    {
        $mainframe = JFactory::getApplication();
        $db = JFactory::getDBO();
        // simple performance check to determine whether bot should process further
        if (JString::strpos($row->text, 'jaloadposition') === false) {
            return true;
        }
        if (!isset($row->text)) {
            $row->text = isset($row->fulltext) ? $row->fulltext : $row->introtext;
        }
        // Get plugin info
        $plugin = JPluginHelper::getPlugin('content', 'jaloadmodule');

        // expression to search for
        $regex = '/{jaloadposition\s*.*?}/i';

        $pluginParams = new JRegistry($plugin->params);

        // check whether plugin has been unpublished
        if (!$pluginParams->get('enabled', 1)) {
            $row->text = preg_replace($regex, '', $row->text);
            return true;
        }
        // find all instances of plugin and put in $matches
        preg_match_all($regex, $row->text, $matches);
        // Number of plugins
        $count = count($matches[0]);

        // plugin only processes if there are any instances of the plugin in the text
        if ($count) {
            // Get plugin parameters
            $style = $pluginParams->def('style', -2);

            $this->processPositions($row, $matches, $count, $regex, $style);
        }
    }


    /**
     *
     * process positions modules in article
     * @param object $row article
     * @param array $matches all instances
     * @param int $count Number of plugins
     * @param string $regex expression to search
     * @param string $style style for result
     * @return string article text
     */
    function processPositions(&$row, &$matches, $count, $regex, $style)
    {
        for ($i = 0; $i < $count; $i++) {
            $markup = $matches[0][$i];

            $regexParams = '/([a-zA-Z0-9\_\-]+)\s*=\s*[\'|\"]([^\'\"]*?)[\'|\"]/';
            $matchesParams = array();
            preg_match_all($regexParams, $markup, $matchesParams);

            /**
             * get position and custom params
             */
            $load = '';
            $customParams = array();
            $countParams = count($matchesParams[0]);
            if ($countParams) {
                for ($j = 0; $j < $countParams; $j++) {
                    if ($matchesParams[1][$j] == 'japos') {
                        $load = $matchesParams[2][$j];
                    } else {
                        $customParams[$matchesParams[1][$j]] = $matchesParams[2][$j];
                    }
                }
            }

            if (!empty($load)) {
                $modules = $this->loadPosition($load, $customParams, $style);
            } else {
                $modules = '';
            }

            $row->text = str_replace($matches[0][$i], $modules, $row->text);
        }

        // removes tags without matching module positions
        $row->text = preg_replace($regex, '', $row->text);
    }


    /**
     *
     * load module content of position param
     * @param string $position
     * @param array $customParams
     * @param string $style
     * @return string content of all modules in position param
     */
    function loadPosition($position, $customParams = array(), $style = -2)
    {
        $document = JFactory::getDocument();
        $renderer = $document->loadRenderer('module');
        $contents = '';
        $title = isset($customParams['title']) ? $customParams['title'] : null;
        $modules = JModuleHelper::getModules($position);
        ob_start();
        foreach ($modules as $module) {
            if (!is_object($module)) {
                $module = JModuleHelper::getModule($module, $title);
            }

            if (is_object($module)) {
                /**
                 * override module params
                 */
                $mod_params = new JRegistry($module->params);
                foreach ($customParams as $pKey => $pVal) {
                    $mod_params->set($pKey, $pVal);
                }
                $module->params = $mod_params->toString();
                //render content
                echo $renderer->render($module);
            }

        }
        $contents = ob_get_clean();
        return $contents;
    }
}
?>