<?php
// $Id: wysiwyg_imageupload.ajax.inc,v 1.1.2.24 2010/05/01 10:39:48 eugenmayer Exp $

# Copyright (c) 2010 Impressive.media
# Author: Eugen Mayer

/*
 * Called through ajax(AHAH), uploading an image and replacing
 * the upload form with an image-details form, if successfully uploaded.
 */
function _wysiwyg_imageupload_upload_js($node_form_build_id) {
  // Load the cache which includes the currently allready uploaded files.
  $cached_files = cache_get('wysiwyg_imageupload_'.$node_form_build_id);

  // Yet no file, initialize the array.
  if(empty($cached_files)) {
    $cached_files = new stdClass();
    $cached_files->data = array();
  }
  $cached_files = $cached_files->data;

  // Handle new uploads. Create the files in the files table and make them temperory.
  // The will need to be made persistend on form submit in the hook_comment or hook_nodeapi
  $imgDetails = _wysiwyg_imageupload_upload_file();

  // remove all status messages
  //drupal_get_messages('status',true);
  if ($imgDetails->filepath != "") {
    $cached_files[$imgDetails->fid] = $imgDetails;
    cache_set( 'wysiwyg_imageupload_'.$node_form_build_id, $cached_files, 'cache', CACHE_TEMPORARY );

    // We save the filepath in our cache, so we dont need to pass it later as a GET variable.
    // (when we let the html object generate using ajax).
    $cacheid = uniqid();
    cache_set($cacheid , $imgDetails->filepath, 'cache',CACHE_TEMPORARY );

    // Save the main form in the cache, adding the file.
    // No errors, so lets replace the upload widget with the image details
    $title = $imgDetails->filename;

    // This is our thumbnail. It also saves the cacheid in alt. We will inject this into the details form.
    // TODO: maybe really generate a small thumbnail and not reuse / resize the original using the browser.
    $img = "<img id='uploadedImage' title='$title' alt='$cacheid' height='200px;border:1px solid black;margin:auto' src='". base_path() . $imgDetails->filepath ."'>";

    // Create the form image detail form.
    $form = array();
    $form_state = array();
    $form = _wysiwyg_imageupload_details_form($title,$img);
    $form = form_builder('wysiwyg_imageupload_detailsform', $form, $form_state);
    $output = theme('status_messages') . drupal_render($form);
  }
  else {
    drupal_set_message(t('Select an image to upload first'),'error');
    $output = theme('status_messages');

    $form_state = array();
    $form = array();
    $form['image_upload'] = array(
      '#type' => 'fieldset',
      '#title'=> t('Upload image'),
      '#prefix' => '<div id="file_upload_group">',
      '#suffix' => '</div>');
    _wysiwyg_imageupload_form_add_uploadfields($form,$node_form_build_id);
    $form = form_builder('wysiwyg_imageupload_upload', $form, $form_state);
    $output .= $output . drupal_render($form);
  }
  // As this is an AHAH callback, lets convert to JSON and return.
  print drupal_to_js(array('status' => TRUE, 'data' => $output));
  exit;
}

/*
 * Ajax callback.
 * Using the cacheID to determine the filepath and returns a html image object.
 * Renders the image using imagecache.
 */
function _wysiwyg_imageupload_show_image($cacheID,$preset,$title) {
  $preset = check_plain($preset);
  $title = check_plain($title);
  $filepath = cache_get($cacheID,'cache');
  $GLOBALS['devel_shutdown'] = FALSE;
  $output = theme('imagecache',$preset,$filepath->data, $filepath->data,$title);
  print $output;
  exit;
}
